/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.util.Enumeration;
import java.util.Vector;
import org.havi.ui.HToggleButton;

public class HToggleGroup {
    private boolean enabled = true;
    private boolean forceSelection = false;
    private HToggleButton current = null;
    private Vector buttons = new Vector();

    public HToggleButton getCurrent() {
        return this.current;
    }

    public void setCurrent(HToggleButton selection) {
        if (selection == null) {
            HToggleButton tmp = this.getCurrent();
            if (tmp != null && this.getForcedSelection() && this.buttons.size() > 0) {
                tmp.setSwitchableState(true);
            } else {
                this.current = null;
                if (tmp != null) {
                    tmp.setSwitchableState(false);
                }
            }
        } else if (this.buttons.contains(selection) && this.getCurrent() != selection) {
            this.current = selection;
            selection.setSwitchableState(true);
            this.unswitch(selection);
        }
    }

    public void setForcedSelection(boolean forceSelection) {
        this.forceSelection = forceSelection;
        if (forceSelection && this.getCurrent() == null && this.buttons.size() > 0) {
            this.forceSelect();
        }
    }

    public boolean getForcedSelection() {
        return this.forceSelection;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        Enumeration e = this.buttons.elements();
        while (e.hasMoreElements()) {
            this.setEnabled((HToggleButton)e.nextElement(), enable);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void add(HToggleButton button) {
        if (!this.buttons.contains(button)) {
            this.buttons.addElement(button);
            this.setEnabled(button, this.isEnabled());
            if (this.getForcedSelection() && this.buttons.size() == 1 && this.getCurrent() != button) {
                button.setSwitchableState(true);
                this.current = button;
            } else if (button.getSwitchableState()) {
                this.current = button;
                if (this.buttons.size() > 1) {
                    this.unswitch(button);
                }
            }
        }
    }

    protected void remove(HToggleButton button) {
        if (!this.buttons.removeElement(button)) {
            throw new IllegalArgumentException("Not a member of this HToggleGroup");
        }
        if (button == this.getCurrent()) {
            this.current = null;
            if (this.getForcedSelection() && this.buttons.size() > 0) {
                this.current = null;
                this.forceSelect();
            }
        }
    }

    private void unswitch(HToggleButton button) {
        Enumeration e = this.buttons.elements();
        while (e.hasMoreElements()) {
            HToggleButton b = (HToggleButton)e.nextElement();
            if (b == button) continue;
            b.setSwitchableState(false);
        }
    }

    private void forceSelect() {
        if (this.buttons.size() > 0) {
            HToggleButton b = (HToggleButton)this.buttons.elementAt(0);
            b.setSwitchableState(true);
            this.current = b;
        }
    }

    private void setEnabled(HToggleButton tb, boolean enable) {
        int state = tb.getInteractionState();
        tb.setInteractionState(enable ? state & 0xFFFFFFFB : state | 4);
    }
}

